(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct

    fun ibr rdr the_cstrm =
    let
	(*  Read all characters to the end of the
	    string or a newline.  This returns the
	    line and the rest of the stream.
	*)
	fun get_line cstrm rev_line =
	(
	    case rdr cstrm of
	      NONE => (cstrm, implode(rev rev_line))
	      			(* ran out of chars *)

	    | SOME (c, rest) => 
	    (
		if c = #"\n"
		then
		    (rest, implode(rev rev_line))
		else
		    get_line rest (c::rev_line)
	    )
	)

	val (strm_out, line) = get_line the_cstrm []
	val l1 = Substring.all line

	val (i, l2) = valOf(Int.scan StringCvt.DEC
				Substring.getc l1)
	val (b, l3) = valOf(Bool.scan Substring.getc l2)
	val (r, l4) = valOf(Real.scan Substring.getc l3)
    in
	SOME((i, b, r), strm_out)
    end
    handle Option => NONE



    fun main(arg0, argv) =
    let
	val text = "\
		\  123 true  23.4       \n\
		\  -1  false -1.3e3     \n\
		\"
    in
	case StringCvt.scanString ibr text of
	  NONE => print "ibr failed\n"

	| SOME (i, b, r) => print(concat[
		Int.toString i, " ",
		Bool.toString b, " ",
		Real.toString r, "\n"
		]);

        OS.Process.success
    end


    val _ = SMLofNJ.exportFn("ibr_cvt", main)
end
