(*  Copyright (c) 2001 Anthony L Shipman *)



structure Timeouts =
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    fun delta() =
    let
	val tmevt = CML.timeOutEvt (Time.fromSeconds 5)
    in
	print "Waiting for the timeout\n";
	CML.sync tmevt;

	print "Delay\n";
	CML.sync (CML.timeOutEvt (Time.fromSeconds 1));

	print "Waiting again for the timeout\n";
	CML.sync tmevt;

	print "Done\n"
    end



    fun abs() =
    let
	val when = Time.+(Time.now(), Time.fromSeconds 5)
	val tmevt = CML.atTimeEvt when
    in
	print "Waiting for the timeout\n";
	CML.sync tmevt;

	print "Delay\n";
	CML.sync (CML.timeOutEvt (Time.fromSeconds 2));

	print "Waiting again for the timeout\n";
	CML.sync tmevt;

	print "Delay again\n";
	CML.sync (CML.timeOutEvt (Time.fromSeconds 2));

	print "Waiting again for the timeout\n";
	CML.sync tmevt;

	print "Done\n"
    end



    fun main(arg0, argv) =
    let
	fun run() =
	let
	in
	    case argv of
	      ["delta"] => delta()
	    | ["abs"]   => abs()
	    | _         => ()
	end
    in
	RunCML.doit(run, NONE);
        OS.Process.success
    end
    handle
      x =>
    (
	toErr(concat["Uncaught exception: ", exnMessage x, " from\n"]);
	app (fn s => (print "\t"; print s; print "\n")) (SMLofNJ.exnHistory x);
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("timeouts", main)
end
