(*  Copyright (c) 2001 Anthony L Shipman *)


structure Common =
struct

(*-------------------------------------------------*)
(*  A hash table with string keys. *)

    structure STRT_key =
    struct
	type hash_key = string
	val hashVal = HashString.hashString
	fun sameKey (s1, s2) = (s1 = s2)
    end

    structure STRT = HashTableFn(STRT_key)

    exception NotFound

(*-------------------------------------------------*)

end


structure Environ:
    sig
	val get:    string -> string option
    end =
struct
    open Common
    open SMLofNJ.Weak

    type Table = string STRT.hash_table

    val cache: (Table option) ref weak ref = ref (weak (ref NONE))

    fun table() : Table =
    let
	(*  This takes a NAME=VALUE string *)
	fun fill tbl env =
	let
	    val ss = Substring.all env
	    val str = Substring.string
	    val fields = Substring.fields
			    (fn c => c = #"=") ss
	in
	    case fields of
	      [n, v] => STRT.insert tbl (str n, str v)
	    | [n]    => STRT.insert tbl (str n, "")
	    | _      => ()	(* unrecognisable *)
	end

	fun build() =
	let
	    val tbl = STRT.mkTable(101, NotFound)
	in
	    print "building\n";
	    app (fill tbl) (Posix.ProcEnv.environ());
	    cache := weak (ref (SOME tbl));
	    tbl
	end
    in
	case strong (!cache) of
	  NONE => build()	(* has been collected *)

	| SOME rtbl =>
	(
	    case !rtbl of
	      NONE     => build() (* is not yet built *)
	    | SOME tbl => tbl	  (* table is available *)
	)
    end

    fun get k = STRT.find (table()) k
end


structure Main =
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    fun main(arg0, argv) =
    let
	fun data() = ignore(List.tabulate(100000, fn n => n))
    in
	SMLofNJ.Internals.GC.messages true;
	print(concat["The PATH is ",
		     valOf(Environ.get "PATH"), "\n"]);
	data();
	print(concat["The PATH is ",
		     valOf(Environ.get "PATH"), "\n"]);

        OS.Process.success
    end
    handle x =>
	(toErr(concat["Uncaught exception: ", exnMessage x, "\n"]);
    	    OS.Process.failure)

    val _ = SMLofNJ.exportFn("weak", main)
end


