(*  Copyright (c) 2001 Anthony L Shipman *)



/*  This runs similar tests to speed.sml to compare the speed with C.
*/

#include    <stdio.h>
#include    <string.h>
#include    <sys/time.h>
#include    <sys/types.h>
#include    <sys/stat.h>
#include    <sys/unistd.h>

/*---------------------------------------------------------*/

static int
int_arg(int argc, char** argv)
{
    if (argc > 0)
    {
	return atoi(*argv);
    }
    else
    {
	fprintf(stderr, "Missing an integer argument\n");
	exit(1);
    }
}


static struct timeval	start_time;
static struct timeval	stop_time;


static void
start_timer()
{
    gettimeofday(&start_time, 0);
}


static void
stop_timer(char* msg)
{
    unsigned long   diff;

    gettimeofday(&stop_time, 0);

    diff = (stop_time.tv_sec - start_time.tv_sec) * 1000000;
    diff += (stop_time.tv_usec - start_time.tv_usec);

    printf("Timing %s: %lu usecs\n", msg, diff);
}



static void
countup(int argc, char** argv)
{
    int	    max_cnt = int_arg(argc, argv);
    int	    i;
    int	    j = 0;

    start_timer();

    for(i = 0; i < max_cnt; i++)
    {
	j++;
    }

    stop_timer("countup");
    printf("reached %d\n", j);	/* ensure j is used. */
}



static void
countdown(int argc, char** argv)
{
    int	    max_cnt = int_arg(argc, argv);
    int	    i;
    int	    j = 0;

    start_timer();

    for(i = max_cnt; i != 0; i--)
    {
	j++;
    }

    stop_timer("countdown");
    printf("reached %d\n", j);	/* ensure j is used. */
}


/*---------------------------------------------------------*/

static int
file_size(char* name)
{
    struct stat buf;

    stat(name, &buf);
    return buf.st_size;
}




static void
countlines(int argc, char** argv)
{
    char*   name;
    int	    size;
    char*   text;
    FILE*   file;
    int	    i, len;


    if (argc > 0)
    {
	name = *argv;
    }
    else
    {
	fprintf(stderr, "Missing the file name\n");
	exit(1);
    }

    /*	Measure the time to read the file including memory operations.
    */
    start_timer();

    size = file_size(name);
    text = malloc(size);

    file = fopen(name, "r");
    fread(text, size, 1, file);
    fclose(file);

    stop_timer("countlines readall");

    /*	Count the number of \n in the usual way.
    */
    start_timer();

    for(i = 0, len = 0; i < size; i++)
    {
	if (text[i] == '\n')
	{
	    len++;
	}
    }

    stop_timer("countlines forloop");
    free(text);
}


/*---------------------------------------------------------*/

typedef struct list_entry
{
    int			n;
    struct list_entry*	next;
} ListEntry;



void
linkedlist(int argc, char** argv)
{
    /*	Build a linked list and then free it.
    */
    int		max_cnt = int_arg(argc, argv);
    ListEntry*	p;
    ListEntry*	last = 0;
    int		n;

    start_timer();

    for(n = 0; n < max_cnt; n++)
    {
	p = (ListEntry*)malloc(sizeof(ListEntry));
	p->next = last;
	p->n = n;
	last = p;
    }

    for(p = last; p; p = last)
    {
	last = p->next;
	free(p);
    }

    stop_timer("linkedlist total");
}


/*---------------------------------------------------------*/

int
main(int argc, char** argv)
{
    argc--;
    argv++;

    if (argc == 0)
    {
	fprintf(stderr, "no test was specified\n");
	exit(1);
    }
    else
    {
	if (strcmp(argv[0], "countup") == 0)
	{
	    countup(--argc, ++argv);
	}
	else
	if (strcmp(argv[0], "countdown") == 0)
	{
	    countdown(--argc, ++argv);
	}
	else
	if (strcmp(argv[0], "countlines") == 0)
	{
	    countlines(--argc, ++argv);
	}
	else
	if (strcmp(argv[0], "linkedlist") == 0)
	{
	    linkedlist(--argc, ++argv);
	}
	else
	{
	    fprintf(stderr, "Unrecognised test %s\n", argv[0]);
	    exit(1);
	}
    }


    return 0;
}
