(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct

    fun toErr s = TextIO.output(TextIO.stdErr, s)


    type PList = exn list

    exception PFruit of string
    exception PNum   of int

    val fruit = [PFruit "apple", PNum 5]

    fun get_fruit []            = NONE
    |   get_fruit (PFruit f::_) = SOME f
    |   get_fruit (_::rest)     = get_fruit rest


    fun new_prop dflt =
    let
	exception E of 'a

	fun get []        = NONE
	|   get (E v::_)  = SOME v
	|   get (_::rest) = get rest

	fun set props v = (E v)::props

	fun dummy() = E dflt
    in
	(get, set)
    end

    val (get_colour, set_colour) = new_prop "colour"
    val props2       = set_colour fruit "red"

    val (get_weight, set_weight) = new_prop 0.0
    val props3       = set_weight props2 0.75

    fun report() =
    (
	print(concat[
	    "The colour is ", valOf(get_colour props3),
	    " and the weight is ",
	    Real.toString(valOf(get_weight props3)),
	    "\n"])
    )


    fun main(arg0, argv) =
    (
	report();
	OS.Process.success
    )
    handle x =>
    (
	toErr(exnMessage x); toErr("\n");
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("dyn", main)
end

