(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: mutex.sml,v 1.2 2002/03/10 17:17:35 felix Exp $ *)

(*  This implements a mutex to lock access to a critical section. The section
    is represented by a function.
*)

signature MUTEX =
sig
    type Mutex

    (*	Mutex values can be saved over an exportML so you can
	"statically" create them.
    *)
    val create:	    unit -> Mutex

    (*	This runs the function in the critical section.
	This will work with CML running or not.
    *)
    val lock:	    Mutex -> (unit -> 'a) -> 'a
end



structure Mutex: MUTEX =
struct
    structure SV = SyncVar

    type Mutex = bool SV.mvar


    fun create() = SV.mVarInit true


    fun lock mutex func =
    (
	SV.mTake mutex;
	let
	    val r = func()
	in
	    SV.mPut(mutex, true);
	    r
	end
	handle x => (
	    SV.mPut(mutex, true);
	    raise x
	    )
    )

end
