(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: t_utils.sml,v 1.3 2001/06/07 01:40:50 felix Exp $ *)

signature TEST_UTILS =
sig
    val expectS:	string -> string -> string -> unit
    val expectSOpt:	string -> string option -> string -> unit
    val expectI:	int -> int -> string -> unit
    val expectIOpt:	int -> int option -> string -> unit
    val expectEmpty:	'a option -> string -> unit

    val fail:	string -> unit

    val numFailures:	unit -> int
end



structure TestUtils: TEST_UTILS =
struct

(*------------------------------------------------------------------------------*)

    val failures = ref 0



    fun expectS str s2 msg =
    (
	if str = s2
	then
	    ()
	else
	    fail (concat[msg, ", expected '", str, "', found '", s2, "'"])
    )



    and expectSOpt str opt msg =
    (
	case opt of
	  NONE => fail (msg ^ ", the field is NONE")

	| SOME s => 
	(
	    if s = str
	    then
		()
	    else
		fail (concat[msg, ", expected '", str,
			         "', found '", s, "'"])
	)
    )


    and expectI i1 i2 msg =
    (
	if i1 = i2
	then
	    ()
	else
	    fail (concat[msg, ", expected ", Int.toString i1,
	                      ", found ", Int.toString i2])
    )




    and expectIOpt i opt msg =
    (
	case opt of
	  NONE => fail (msg ^ ", the field is NONE")

	| SOME j => 
	(
	    if i = j
	    then
		()
	    else
		fail (concat[msg, ", expected '", Int.toString i,
			         "', found '", Int.toString j, "'"])
	)
    )


    and expectEmpty opt msg =
    (
	case opt of
	  NONE => ()

	| SOME s => fail (concat[msg, ", expected it to be empty"])
    )


    and fail msg =
    (
	failures := !failures + 1;
	TextIO.output(TextIO.stdErr, "FAILURE " ^ msg ^ "\n")
    )


    and numFailures() = !failures

(*------------------------------------------------------------------------------*)

end
