(*  Copyright (c) 2001 Anthony L Shipman *)

structure IETFLex=
   struct
    structure UserDeclarations =
      struct
(* $Id: ietf.lex,v 1.2 2001/07/07 19:12:48 felix Exp $ *)

(*
    This contains the lex file for lines in IETF messages such as HTTP
    headers. This is just a short cut to splitting a line into tokens,
    symbols and quoted strings.  We assume that there are no CRLF
    characters.

    The types are accessible directly out of IETFLex.UserDeclarations.
*)

    open IETF_Part
    type lexresult = Part

    fun eof() = TEOF

    (*	Strip off the surrounding quotes. *)
    fun fix_str s = Token(String.substring(s, 1, size s - 2))

(*--------------------------------------------------------------------------*)

(*  %full selects an 8 bit character set.
    token chars are all but ()<>@,;:\\"/[]?={} \t\000-\031\127
    Due to a bug in ml-lex we can't include a ] in a character set.
    The \h stands for all characters 0x80 and up.
*)

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (1, 
"\003\003\003\003\003\003\003\003\003\025\000\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\025\004\022\004\004\004\004\004\021\020\004\004\019\004\004\018\
\\004\004\004\004\004\004\004\004\004\004\017\016\015\014\013\012\
\\011\004\004\004\004\004\004\004\004\004\004\004\004\004\004\004\
\\004\004\004\004\004\004\004\004\004\004\004\010\009\008\004\004\
\\004\004\004\004\004\004\004\004\004\004\004\004\004\004\004\004\
\\004\004\004\004\004\004\004\004\004\004\004\007\004\006\004\003\
\\004\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\
\\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003\003"
),
 (4, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\005\000\005\005\005\005\005\000\000\005\005\000\005\005\000\
\\005\005\005\005\005\005\005\005\005\005\000\000\000\000\000\000\
\\000\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\000\000\000\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\000\005\000\005\000\
\\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (22, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\023\023\024\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\000\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023"
),
 (25, 
"\000\000\000\000\000\000\000\000\000\026\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [], trans = 1},
{fin = [], trans = 1},
{fin = [(N 45)], trans = 0},
{fin = [(N 5),(N 45)], trans = 4},
{fin = [(N 5)], trans = 4},
{fin = [(N 43),(N 45)], trans = 0},
{fin = [(N 41),(N 45)], trans = 0},
{fin = [(N 35),(N 45)], trans = 0},
{fin = [(N 27),(N 45)], trans = 0},
{fin = [(N 33),(N 45)], trans = 0},
{fin = [(N 19),(N 45)], trans = 0},
{fin = [(N 37),(N 45)], trans = 0},
{fin = [(N 17),(N 45)], trans = 0},
{fin = [(N 39),(N 45)], trans = 0},
{fin = [(N 15),(N 45)], trans = 0},
{fin = [(N 23),(N 45)], trans = 0},
{fin = [(N 25),(N 45)], trans = 0},
{fin = [(N 31),(N 45)], trans = 0},
{fin = [(N 21),(N 45)], trans = 0},
{fin = [(N 13),(N 45)], trans = 0},
{fin = [(N 11),(N 45)], trans = 0},
{fin = [(N 29),(N 45)], trans = 22},
{fin = [], trans = 22},
{fin = [(N 9)], trans = 0},
{fin = [(N 2),(N 45)], trans = 25},
{fin = [(N 2)], trans = 25}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val INITIAL = STARTSTATE 1;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput =
let	val yygone0=1
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  11 => (TSpec (String.sub(yytext, 0)))
| 13 => (TSpec (String.sub(yytext, 0)))
| 15 => (TSpec (String.sub(yytext, 0)))
| 17 => (TSpec (String.sub(yytext, 0)))
| 19 => (TSpec (String.sub(yytext, 0)))
| 2 => (TWh yytext)
| 21 => (TSpec (String.sub(yytext, 0)))
| 23 => (TSpec (String.sub(yytext, 0)))
| 25 => (TSpec (String.sub(yytext, 0)))
| 27 => (TSpec (String.sub(yytext, 0)))
| 29 => (TSpec (String.sub(yytext, 0)))
| 31 => (TSpec (String.sub(yytext, 0)))
| 33 => (TSpec (String.sub(yytext, 0)))
| 35 => (TSpec (String.sub(yytext, 0)))
| 37 => (TSpec (String.sub(yytext, 0)))
| 39 => (TSpec (String.sub(yytext, 0)))
| 41 => (TSpec (String.sub(yytext, 0)))
| 43 => (TSpec (String.sub(yytext, 0)))
| 45 => (TBad (String.sub(yytext, 0)))
| 5 => (Token yytext)
| 9 => (fix_str yytext)
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord(String.sub(!yyb,l))
		val NewState = Char.ord(String.sub(trans,NewChar))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
