(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: t_utils.sml,v 1.1 2001/06/11 12:26:58 felix Exp $ *)

structure t_Utils =
struct

    structure TU = TestUtils
    structure IP = IETF_Part

(*------------------------------------------------------------------------------*)


    (*	Test base64 decoding.
    	REVISIT - test with 0, 1 and 3 = padding.
    *)


    fun test_b64() =
    (
	print "Testing base64 decoding.\n";

	TU.expectSOpt "Aladdin:open sesame"  
		    (IETF_Utils.base64Decode "QWxhZGRpbjpvcGVuIHNlc2FtZQ==")
		   "base64 a";


	TU.expectS "QUI="
		    (IETF_Utils.base64Encode "AB")
		   "base64 b";

	TU.expectS "QUJD"
		    (IETF_Utils.base64Encode "ABC")
		   "base64 c";

	TU.expectS "QWxhZGRpbjpvcGVuIHNlc2FtZQ=="
		    (IETF_Utils.base64Encode "Aladdin:open sesame")
		   "base64 d";
	()
    )


    fun test_split() =
    let
	val _     = print "Testing line splitting.\n";
	val text  = " abc/def;x=\" y\"\t"
	val parts = IETF_Line.split text
    in

	if parts = [
		IP.TWh   " ",
		IP.Token "abc",
		IP.TSpec #"/",
		IP.Token "def",
		IP.TSpec #";",
		IP.Token "x",
		IP.TSpec #"=",
		IP.Token " y",
		IP.TWh   "\t"
		]
	then
	    ()
	else
	    TU.fail "split 1";

	if IETF_Line.join parts = " abc/def;x=\" y\""
	then
	    ()
	else
	    TU.fail "split 2";

	()
    end

(*------------------------------------------------------------------------------*)


    fun run() =
    (
	test_b64();
	test_split();

	()
    )

end
